<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../../componenti/include/includeBaseComponenti.php";
    // solo i super admin hanno accesso agli strumenti
    if($_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>Amministrazione di Geecom CMS - strumento test mail</title>

    <?php
        include "../../componenti/include/cssBaseComponenti.php";
    ?>
  </head>
  <body>
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
    ?>
	  
    <main role="main" class="bg-light">
        <div id="dashboard" class="container-fluid">
            <div class="row">
                <div class="col-md-6 col-xl-4 mx-auto py-4">
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header" >
                            <span class="card-title">Strumento di test per l'invio di email </span>
                        </div>
                        <div class="card-body">
                            <p>Un'email di prova verrà inviata dall'indirizzo <b>geecom@<?= str_replace(["http://","http://www","https://","https://www."],"",$impostazioni["urlSito"]) ?></b></p>
                            
                            <p>L'indirizzo IP del server è: <?= $_SERVER["SERVER_ADDR"] ?><i class="fas fa-info-circle ml-2 text-muted" data-toggle="popover" title="Informazioni sull'IP" data-content="Può essere necessario inserire questo indirizzo IP nel record SPF del tuo dominio"></i></p>
                            <div class="form-group mt-3">
                                <label for="titolo-articolo">Destinatario</label>
                                <input  type="email" class="form-control" id="destinatario" name="email" value="<?php echo((isset($utente)? $utente["email"] : ""))?>" placeholder="indirizzo email">
                            </div>
                            <button class="btn btn-primary float-right" onclick="inviaMailDiTest()">Invia email di prova</button>
                        </div>
                    </div>
                </div><!-- /Colonna principale -->
            </div>
        </div>
    </main>
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../../include/modal/operazioneCompletata.php";
        
        include "../../componenti/include/jsBaseComponenti.php";
    ?>
	  
    <script>
        function inviaMailDiTest() {
            var email = document.getElementById("destinatario").value;
            
            if(email.length===0) {
                alert("Inserisci la mail del destinatario");
            }
            else {
                $.ajax({
                    type:"POST",
                    url:"inviaMailDiTest.php",
                    data:{
                        email:email
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            $('#labelOperazioneCompletata').text("Email inviata all'indirizzo specificato");
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
        }
    </script>
  </body>
</html>